import { View, FlatList } from "react-native";
import React, { useEffect, useMemo } from "react";
import { useNavigation } from "@react-navigation/native";
import FeatureProductSkeleton from "../../../skeletons/screens/home/FeatureProductSkeleton";
import {
    getVendorProducts,
    getMoreVendorProducts,
} from "../../../../redux/slices/vendor/vendorProducts";
import { useDispatch, useSelector } from "react-redux";
import { BASE_API_URL_STG } from "@env";
import CustomActiveIndicator from "../../CustomLoader/CustomActiveIndicator";
import SingleProduct from "../../SingleProduct/SingleProduct";

const AllProducts = ({ shop_alias }) => {
    const navigation = useNavigation();
    const dispatch = useDispatch();

    const { vendorProducts, nextPageUrl, loading, loadMore, shopAlias } = useSelector(
        (state) => state.vendorProducts
    );

    useEffect(() => {
        let isMounted = true;
        if(shopAlias != shop_alias) {
            const URL = `${BASE_API_URL_STG}/user/shop/${shop_alias}`;
            if (isMounted) {
                dispatch(getVendorProducts(URL));
            }
        }
        return () => {
            isMounted = false;
        };
    }, [shop_alias, dispatch]);

    const handleMoreData = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreVendorProducts(nextPageUrl));
        }
        return () => {
            isMounted = false;
        };
    };

    const memorizeItem = useMemo(
        () =>
            ({ item }) =>
                <SingleProduct item={item} navigation={navigation} />,
        []
    );

    const columnWrapperStyle = { justifyContent: "space-between" };

    return (
        <View>
            <View>
                {loading ? (
                    <FeatureProductSkeleton />
                ) : (
                    <FlatList
                        data={vendorProducts}
                        keyExtractor={(_, i) => `vp${i}`}
                        renderItem={memorizeItem}
                        showsVerticalScrollIndicator={false}
                        numColumns={2}
                        columnWrapperStyle={columnWrapperStyle}
                        windowSize={10}
                        onEndReachedThreshold={1}
                        onEndReached={handleMoreData}
                        initialNumToRender={4}
                    />
                )}
            </View>
            {loadMore && <CustomActiveIndicator />}
        </View>
    );
};

export default AllProducts;
